function em = scaleEMachine(em, rescaled_em_ratedPower)
%scaleEMachine
%   rescaled_em_ratedPower: kW

% Scaling factor
base_ratedPower = em.ratedPwr;
scalingFactor = rescaled_em_ratedPower/base_ratedPower;

em.ratedPwr = rescaled_em_ratedPower;
em.inertia = em.inertia * scalingFactor;
em.mass = em.mass * scalingFactor;

% Torque limit map
em.maxTrq.Values = em.maxTrq.Values * scalingFactor;
em.minTrq.Values = em.minTrq.Values * scalingFactor;

% Efficiency map
if isfield(em, 'effMap')
    em.effMap.GridVectors{2} = em.effMap.GridVectors{2} * scalingFactor;
elseif isfield(em, 'trqLossMap')
    em.trqLossMap.GridVectors{2} = em.trqLossMap.GridVectors{2} * scalingFactor;
    em.trqLossMap.Values = em.trqLossMap.Values * scalingFactor;
end
end

